import { ModalFormData } from "@minecraft/server-ui";
import { Student } from "./Humans";
import { Player } from "@minecraft/server";
import { School } from "./School";
/**
 * Represents a SchoolClass
 */
class SchoolClass{
    /**
     * 
     * @param {number} grade What grade is this class?
     * @param {string} letter What is this class name letter?
     * @param {string|number} id 
     */
    constructor(grade, letter, id){
        /**
         * @type {number}
         * @description This class' grade
         */
        this.grade = grade;
        /**
         * @type {string}
         * @description This class' letter
         */
        this.letter = letter;
        /**
         * @type {Array<Student>}
         * @description Students in this class
         */
        this.students = [];
        /**
         * @type {Human}
         * @description This class' main teacher
         */
        this.mainTeacher = "";
        /**
         * @type {Array<ClassSchedule>}
         * @description This class' work schedule
         */
        this.schedule = [];
        /**
         * @type {number}
         * @description This class' identifier in a school
         */
        this.schoolClassIdentifier = NaN;
        /**
         * @type {number|string}
         * @description This class' universal identifier
         */
        this.identifier = id;
        this.oldStudents = [];
    };
    /**
     * Adds new students to this class
     * @param {Array<Student>} students New students to add into the class
     */
    newStudents(students){
        let denied = [];
        for(let s = 0; s < students.length; s++){ for(let i = 0; this.students.length; i++){ if(students[s].identifier == this.students[i].identifier){ console.warn("Student already in class!"); denied.push(s); break; }; }; };
        for(let ss = 0; ss < students.length; ss++){ if(denied.includes(ss)){ console.warn(`Student with Id ${students[ss].identifier} denied`); }else { this.students.push(students[ss]); } };
    };
};
/**
 * @description An Object with Subjects, that can be used in Schools
 */
class SchoolSubject{
    static Ma = "math";
    static Geo = "geography";
    static En = "english";
    static Bio = "biology";
    static De = "german";
    static Fr = "french";
    static Spa = "spanish";
    static Sp = "sports";
    static Sci = "science";
    static Phy = "physics";
    static Mu = "music";
    static His = "history";
    static Art = "arts";
    static Co = "computerscience";
    static Po = "politics";
    static AllTogether = [this.Ma, ", ", this.Geo, ", ", this.En, ", ", this.Bio, ", ", this.De, ", ", this.Fr, ", ", this.Spa, ", ", this.Sp, ", ", this.Sci, ", ", this.Phy, ", ", this.Mu, ", ", this.His, ", ", this.Art, ", ", this.Co, ", ", this.Po].toString();
    
};

export {SchoolClass, SchoolSubject};
/**
 * Allows a PLayer to create a SchoolClass in-game
 * @param {Player} player The Player to build the class
 * @param {School} school The school this Class will be built in
 */
export function createSchoolClass(player, school){
    let main = new ModalFormData(); main.textField("Letter", "a, A, bb, Dc..."); main.slider("Grade", 1, 12, 1, 1); main.textField("Class Identifier; MAY NOT BE A DUPLICATE", "identifier"); main.show(player).then((resp)=>{if(resp.canceled){return;}; let newClass = new SchoolClass(resp.formValues[1], resp.formValues[0], resp.formValues[2]); school.registerClass(newClass);})
};